IF NOT EXISTS(
	SELECT 
		1
	FROM 
		 sys.tables 
	WHERE 
		NAME = 'EST_PROD_TBL_COMIS' )
BEGIN
	
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[EST_PROD_TBL_COMIS](
	[CD_EMP] [int] NOT NULL,
	[CD_TBL_COMIS] [int] NOT NULL,
	[DS_TBL_COMIS] [nvarchar](100) NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[DT_ULT_ALT] [datetime] NULL,
	[STS_TBL] [int] NULL,
	[TP_VALOR] [int] NOT NULL,
	[FLAG_DESC_OUTR_TBL] [int] NOT NULL,
 CONSTRAINT [PK_EST_PROD_TBL_COMIS] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_TBL_COMIS] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_PROD_TBL_COMIS]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_COMIS_GLB_USU] FOREIGN KEY([CD_USU])
REFERENCES [dbo].[GLB_USU] ([CD_USU])
ON UPDATE CASCADE

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS] CHECK CONSTRAINT [FK_EST_PROD_TBL_COMIS_GLB_USU]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_COMIS_PRC_EMP] FOREIGN KEY([CD_EMP])
REFERENCES [dbo].[PRC_EMP] ([CD_EMP])

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS] CHECK CONSTRAINT [FK_EST_PROD_TBL_COMIS_PRC_EMP]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS] ADD  DEFAULT ((0)) FOR [TP_VALOR]

ALTER TABLE [dbo].[EST_PROD_TBL_COMIS] ADD  DEFAULT ((0)) FOR [FLAG_DESC_OUTR_TBL]


END